<?php

class DBInfo
{
    protected $_host = null;
    protected $_user = null;
    protected $_pwd = null;

    function __construct($host, $user, $pwd)
    {
        $this->setHost($host);
        $this->setUser($user);
        $this->setPwd($pwd);
    }

    public function setHost($host)
    {
        $this->_host = $host;
    }

    public function getHost()
    {
        return $this->_host;
    }

    public function setPwd($pwd)
    {
        $this->_pwd = $pwd;
    }

    public function getPwd()
    {
        return $this->_pwd;
    }

    public function setUser($user)
    {
        $this->_user = $user;
    }

    public function getUser()
    {
        return $this->_user;
    }

}

class ManagementServerDBInfoRetriever
{
    protected $_cfg_xml = null;

    function __construct($cfg_xml_path)
    {
        $this->_cfg_xml = simplexml_load_file($cfg_xml_path);
    }

    public function getDBInfo()
    {
        $db_host = (string)$this->_cfg_xml->management_server->ip;
        $db_user = (string)$this->_cfg_xml->db->username;
        $db_pwd = (string)$this->_cfg_xml->db->password;
        return new DBInfo($db_host, $db_user, $db_pwd);
    }
}

class ClusterManagementServerDBInfoRetriever
{
    protected $_cfg_xml = null;
    protected $_sc_id = null;

    function __construct($cfg_xml_path, $sc_id)
    {
        $this->_cfg_xml = simplexml_load_file($cfg_xml_path);
        $this->_sc_id = $sc_id;
    }

    public function getDBInfo()
    {
        $cluster_section = "cluster_$this->_sc_id";
        $db_host = (string)$this->_cfg_xml->$cluster_section->management_server->ip;
        $db_user = (string)$this->_cfg_xml->$cluster_section->db->username;
        $db_pwd = (string)$this->_cfg_xml->$cluster_section->db->password;
        return new DBInfo($db_host, $db_user, $db_pwd);
    }
}

class DatabaseConfigManager
{
    protected $_db_info = null;
    protected $_ssh_cmd = null;

    const BACKEND_PHP_PATH = "/opt/TrendMicro/Pixiebob/textUI/backend.php";
    const NOTIFY_CONFIG_CHANGE_CMD = "/bin/sh /opt/TrendMicro/Pixiebob/textUI/notify_configuration_change.sh 2>&1";
    const PHP_BIN_PATH = "/usr/bin/php";
    const CONFIG_SETTER = "set_configuration_to_db";
    const CONFIG_GETTER = "get_configuration_from_db";
    const DB_KEY_CONFIGURATION = "configuration";
    const DB_KEY_CLUSTER_PRE = "cluster_";
    const PATTERN_DB_KEY_CONFIGURATION_SEPARATE_BY_CLUSTER = '/^(?P<config_tag>configuration).(?P<rest>.*$)/';

    function __construct($db_info, $ssh_cmd)
    {
        $this->_db_info = $db_info;
        $this->_ssh_cmd = $ssh_cmd;
    }

    protected function executeConfigCmd($commander, $arg_list, &$out = null)
    {
        $cmd = $this->getConfigCmd($commander, $arg_list);
        exec($cmd, $out_list, $return_code);
        $out = implode($out_list, "\n");
        if ($return_code != 0) throw new Exception("Cannot config to db by $commander and args $arg_list, db info is " . var_export($this, true));
    }

    protected function getConfigCmd($commander, $arg_list)
    {
        $pre_cmd_list = array(DatabaseConfigManager::PHP_BIN_PATH, DatabaseConfigManager::BACKEND_PHP_PATH,
            $commander, $this->_db_info->getHost(), $this->_db_info->getUser(), $this->_db_info->getPwd());
        $cmd_list = array_merge($pre_cmd_list, $arg_list);
        $cmd = implode(' ', $cmd_list);
        return $cmd;
    }

    public function setClusterConfig($key, $value, $sc_id)
    {
        $cluster_section = DatabaseConfigManager::DB_KEY_CLUSTER_PRE . $sc_id;
        $cluster_key = preg_replace(DatabaseConfigManager::PATTERN_DB_KEY_CONFIGURATION_SEPARATE_BY_CLUSTER, "$1.$cluster_section.$2", $key);
        $this->setConfig($cluster_key, $value);
    }


    public function setConfig($key, $value)
    {
        $this->executeConfigCmd(DatabaseConfigManager::CONFIG_SETTER, array($key, $value));
    }

    public function getConfig($key, &$out)
    {
        $this->executeConfigCmd(DatabaseConfigManager::CONFIG_GETTER, array($key), $out);
    }

    public function notifyConfigChange()
    {
        $this->_ssh_cmd->doCmd(DatabaseConfigManager::NOTIFY_CONFIG_CHANGE_CMD);
    }
}
